<?php

function calculateVacationDays($totalVacationDays) {
    $vacationDaysPerYear = 21; // Vacation days for the first five years
    $vacationDaysAfterFiveYears = 30; // Vacation days after the first five years
    
    if ($totalVacationDays <= 0) {
        return 0;
    }
    
    $remainingVacationDays = $totalVacationDays;
    $vacationDays = 0;
    
    // Calculate vacation days for the first five years
    if ($remainingVacationDays >= $vacationDaysPerYear * 5) {
        $vacationDays += $vacationDaysPerYear * 5;
        $remainingVacationDays -= $vacationDaysPerYear * 5;
    } else {
        $vacationDays += $remainingVacationDays;
        $remainingVacationDays = 0;
    }
    
    // Calculate vacation days after the first five years
    if ($remainingVacationDays > 0) {
        $vacationDays += $vacationDaysAfterFiveYears * floor($remainingVacationDays / 365);
        $remainingVacationDays %= 365;
        
        // Adjust vacation days if there are additional days remaining
        if ($remainingVacationDays > 0) {
            if ($remainingVacationDays <= 5 * 21) {
                $vacationDays += $remainingVacationDays;
            } else {
                $vacationDays += 5 * 21 + ($remainingVacationDays - 5 * 21);
            }
        }
    }
    
    return $vacationDays;
}

$totalVacationDays = 2000;
$calculatedVacationDays = calculateVacationDays($totalVacationDays);

echo "Total Vacation Days: " . $calculatedVacationDays;

?>